import boto3
import configparser
import pyscopg2

# Pobranie informacji dotyczących połączenia z bazą danych Redshift.
parser = configparser.ConfigParser()
parser.read("pipeline.conf")
dbname = parser.get("aws_creds", "database")
user = parser.get("aws_creds", "username")
password = parser.get("aws_creds", "password")
host = parser.get("aws_creds", "host")
port = parser.get("aws_creds", "port")

# Nawiązanie połączenia z klastrem Redshift.
rs_conn = psycopg2.connect(
            "dbname=" + dbname
            + " user=" + user
            + " password=" + password
            + " host=" + host
            + " port=" + port)

# Wczytywanie wartości account_id i iam_role z pliku konfiguracyjnego.
parser = configparser.ConfigParser()
parser.read("pipeline.conf")
account_id = parser.get(
                "aws_boto_credentials",
                "account_id")
iam_role = parser.get("aws_creds", "iam_role")

# Wykonanie polecenia COPY w celu wczytania danych do hurtowni danych Redshift.
file_path = "s3://bucket-name/dag_run_extract.csv"

sql = """COPY dag_run_history
        (id,dag_id,execution_date,
        state,run_id,external_trigger,
        end_date,start_date)"""
sql = sql + " from %s "
sql = sql + " iam_role 'arn:aws:iam::%s:role/%s';"

# Utworzenie obiektu kursora i wykonanie polecenia COPY.
cur = rs_conn.cursor()
cur.execute(sql,(file_path, account_id, iam_role))

# Zamknięcie kursora i zatwierdzenie transakcji.
cur.close()
rs_conn.commit()

# Zamknięcie połączenia.
rs_conn.close()
